"""add water system

Revision ID: 531839676f45
Revises: 
Create Date: 2025-07-16 15:01:34.823488

"""
from alembic import op
import sqlalchemy as sa
import geoalchemy2


# revision identifiers, used by Alembic.
revision = '531839676f45'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('contribution_types',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('locations',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('county', sa.String(length=100), nullable=False),
    sa.Column('ward', sa.String(length=100), nullable=False),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('om_visit_types',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('operational_statuses',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('spare_part_types',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=False),
    sa.Column('unit', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('staff_development_needs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('system_types',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('user',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('role', sa.String(length=50), nullable=False),
    sa.Column('password', sa.String(length=255), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('water_assets',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('asset_type', sa.String(length=50), nullable=False),
    sa.Column('installation_date', sa.DateTime(), nullable=False),
    sa.Column('material', sa.String(length=50), nullable=False),
    sa.Column('capacity', sa.Float(), nullable=False),
    sa.Column('location', sa.String(length=150), nullable=False),
    sa.Column('latitude', sa.Float(), nullable=False),
    sa.Column('longitude', sa.Float(), nullable=False),
    sa.Column('status', sa.String(length=30), nullable=False),
    sa.Column('last_maintenance', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('water_quality_test_types',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('work_orders',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('status', sa.String(length=50), nullable=True),
    sa.Column('region', sa.String(length=100), nullable=True),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('water_systems',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('unique_id', sa.String(length=50), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=False),
    sa.Column('type_id', sa.Integer(), nullable=True),
    sa.Column('status_id', sa.Integer(), nullable=True),
    sa.Column('location_id', sa.Integer(), nullable=True),
    sa.Column('geom', geoalchemy2.types.Geometry(geometry_type='POINT', srid=4326, from_text='ST_GeomFromEWKT', name='geometry'), nullable=True),
    sa.ForeignKeyConstraint(['location_id'], ['locations.id'], ),
    sa.ForeignKeyConstraint(['status_id'], ['operational_statuses.id'], ),
    sa.ForeignKeyConstraint(['type_id'], ['system_types.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('unique_id')
    )
    conn = op.get_bind()
    result = conn.execute(
        "SELECT to_regclass('public.idx_water_systems_geom')"
    )
    index_exists = result.scalar() is not None

    if not index_exists:
        with op.batch_alter_table('water_systems', schema=None) as batch_op:
            batch_op.create_index('idx_water_systems_geom', ['geom'], unique=False, postgresql_using='gist')

    op.create_table('community_contributions',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('water_system_id', sa.Integer(), nullable=False),
    sa.Column('contribution_type', sa.Integer(), nullable=False),
    sa.Column('amount', sa.Numeric(), nullable=True),
    sa.Column('date_recorded', sa.Date(), nullable=False),
    sa.ForeignKeyConstraint(['contribution_type'], ['contribution_types.id'], ),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('funding_sources',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('water_system_id', sa.Integer(), nullable=False),
    sa.Column('source_type', sa.String(length=100), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('infrastructure',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('type', sa.String(length=100), nullable=False),
    sa.Column('status', sa.String(length=50), nullable=False),
    sa.Column('capacity', sa.Float(), nullable=True),
    sa.Column('location', sa.String(length=200), nullable=True),
    sa.Column('county', sa.String(length=100), nullable=True),
    sa.Column('water_system_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('om_visits',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('water_system_id', sa.Integer(), nullable=False),
    sa.Column('visit_type', sa.Integer(), nullable=False),
    sa.Column('visit_date', sa.Date(), nullable=False),
    sa.Column('notes', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['visit_type'], ['om_visit_types.id'], ),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('operators',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('water_system_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=200), nullable=True),
    sa.Column('training_supported', sa.Boolean(), nullable=True),
    sa.Column('tariff_charged', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('spare_part_inventories',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('water_system_id', sa.Integer(), nullable=False),
    sa.Column('part_type_id', sa.Integer(), nullable=False),
    sa.Column('quantity', sa.Integer(), nullable=False),
    sa.Column('last_restocked', sa.Date(), nullable=True),
    sa.ForeignKeyConstraint(['part_type_id'], ['spare_part_types.id'], ),
    sa.ForeignKeyConstraint(['water_system_id'], ['water_systems.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('water_quality_tests',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('system_id', sa.Integer(), nullable=False),
    sa.Column('test_type_id', sa.Integer(), nullable=False),
    sa.Column('test_date', sa.Date(), nullable=True),
    sa.Column('value', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['system_id'], ['water_systems.id'], ),
    sa.ForeignKeyConstraint(['test_type_id'], ['water_quality_test_types.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('staff_development_records',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_id', sa.Integer(), nullable=False),
    sa.Column('need_id', sa.Integer(), nullable=False),
    sa.Column('is_met', sa.Boolean(), nullable=False),
    sa.Column('date_met', sa.Date(), nullable=False),
    sa.Column('date', sa.Date(), nullable=True),
    sa.Column('notes', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['need_id'], ['staff_development_needs.id'], ),
    sa.ForeignKeyConstraint(['operator_id'], ['operators.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tariffs',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_id', sa.Integer(), nullable=False),
    sa.Column('for_domestic', sa.Boolean(), nullable=True),
    sa.Column('domestic_type', sa.String(length=100), nullable=True),
    sa.Column('for_productive', sa.Boolean(), nullable=True),
    sa.Column('productive_type', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['operator_id'], ['operators.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('training_records',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('operator_id', sa.Integer(), nullable=False),
    sa.Column('training_type', sa.String(length=200), nullable=False),
    sa.Column('date_received', sa.Date(), nullable=True),
    sa.ForeignKeyConstraint(['operator_id'], ['operators.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # op.drop_table('spatial_ref_sys')  # Removed because PostGIS extension depends on this table
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('spatial_ref_sys',
    sa.Column('srid', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('auth_name', sa.VARCHAR(length=256), autoincrement=False, nullable=True),
    sa.Column('auth_srid', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('srtext', sa.VARCHAR(length=2048), autoincrement=False, nullable=True),
    sa.Column('proj4text', sa.VARCHAR(length=2048), autoincrement=False, nullable=True),
    sa.CheckConstraint('(srid > 0) AND (srid <= 998999)', name='spatial_ref_sys_srid_check'),
    sa.PrimaryKeyConstraint('srid', name='spatial_ref_sys_pkey')
    )
    op.drop_table('training_records')
    op.drop_table('tariffs')
    op.drop_table('staff_development_records')
    op.drop_table('water_quality_tests')
    op.drop_table('spare_part_inventories')
    op.drop_table('operators')
    op.drop_table('om_visits')
    op.drop_table('infrastructure')
    op.drop_table('funding_sources')
    op.drop_table('community_contributions')
    with op.batch_alter_table('water_systems', schema=None) as batch_op:
        batch_op.drop_index('idx_water_systems_geom', postgresql_using='gist')

    op.drop_table('water_systems')
    op.drop_table('work_orders')
    op.drop_table('water_quality_test_types')
    op.drop_table('water_assets')
    op.drop_table('user')
    op.drop_table('system_types')
    op.drop_table('staff_development_needs')
    op.drop_table('spare_part_types')
    op.drop_table('operational_statuses')
    op.drop_table('om_visit_types')
    op.drop_table('locations')
    op.drop_table('contribution_types')
    # ### end Alembic commands ###
