from flask import Blueprint, render_template, abort
from jinja2 import TemplateNotFound

global_bp = Blueprint('global', __name__)

@global_bp.route('/', defaults={'template_name': 'index.html'})
@global_bp.route('/<path:template_name>')
def render_template_page(template_name):
    try:
        return render_template(template_name)
    except TemplateNotFound:
        abort(404)
