# app/models/task_model.py

from app import db
from datetime import datetime

class Task(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    task_name = db.Column(db.String(100), nullable=False)
    assigned_to = db.Column(db.Integer, db.ForeignKey('user.id'), nullable=False)
    #location = db.Column(db.String(200))
    location_latitude = db.Column(db.Float, nullable=False)
    location_longitude = db.Column(db.Float, nullable=False)
    status = db.Column(db.String(50), default='Pending')
    geofence_radius = db.Column(db.Float, default=100)  # Default geofence radius in meters
    priority = db.Column(db.String(20), default='Medium')  # Priority field (Critical, High, Medium, Low)
    due_date = db.Column(db.DateTime)
    completed_at = db.Column(db.DateTime, nullable=True)  # Time when task was completed
    created_at = db.Column(db.DateTime, default=datetime.utcnow)  # Time when task was created
    description = db.Column(db.String(500))

    user = db.relationship('User', backref='tasks')

    def __repr__(self):
        return f'<Task {self.task_name}>'
