# app/models/performance.py

from app import db
from datetime import datetime

class Performance(db.Model):
    __tablename__ = 'performances'

    id = db.Column(db.Integer, primary_key=True)
    asset_id = db.Column(db.Integer, db.ForeignKey('water_systems.id'), nullable=False)
    timestamp = db.Column(db.DateTime, default=datetime.utcnow)
    flow_rate = db.Column(db.Float)
    pressure = db.Column(db.Float)
    reservoir_level = db.Column(db.Float)
    remarks = db.Column(db.String(255))

    asset = db.relationship('WaterSystem', back_populates='performances')
class PerformanceMetrics(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    task_id = db.Column(db.Integer, db.ForeignKey('task.id'), nullable=False)
    timestamp = db.Column(db.DateTime, default=datetime.utcnow)
    pressure = db.Column(db.Float)  # Pressure in bars
    flow_rate = db.Column(db.Float)  # Flow rate in liters per minute
    water_level = db.Column(db.Float)  # Water level in percentage

    task = db.relationship('Task', backref='performance_metrics')

    def __repr__(self):
        return f'<PerformanceMetrics {self.id}>'