# app/models/maintenance.py

from app import db
from datetime import datetime

class Maintenance(db.Model):
    __tablename__ = 'maintenances'

    id = db.Column(db.Integer, primary_key=True)
    asset_id = db.Column(db.Integer, db.ForeignKey('water_systems.id'), nullable=False)
    maintenance_type = db.Column(db.String(100))  # Preventive, Corrective, etc.
    performed_by = db.Column(db.String(100))
    status = db.Column(db.String(50))  # e.g., Completed, In Progress
    date_performed = db.Column(db.DateTime, default=datetime.utcnow)
    notes = db.Column(db.Text)

    asset = db.relationship('WaterSystem', back_populates='maintenances')
