# app/models/infrastructure_model.py

from app.extensions import db

class Infrastructure(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(100), nullable=False)
    type = db.Column(db.String(100), nullable=False)
    status = db.Column(db.String(50), nullable=False)
    capacity = db.Column(db.Float)
    location = db.Column(db.String(200))
    county = db.Column(db.String(100))
    water_system_id = db.Column(db.Integer, db.ForeignKey('water_systems.id'))
    water_system = db.relationship('WaterSystem', back_populates='infrastructure')
