# app/models/form_template.py

from app import db

class FormTemplate(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    task_type = db.Column(db.String(100), nullable=False)  # e.g., 'maintenance', 'water_quality'
    question = db.Column(db.String(255), nullable=False)  # Question label
    field_type = db.Column(db.String(50), nullable=False)  # e.g., 'text', 'dropdown', 'checkbox'
    options = db.Column(db.String(255))  # Options for dropdown or checkboxes, stored as a comma-separated string
    required = db.Column(db.Boolean, default=False)  # Whether the question is required

    def __repr__(self):
        return f'<FormTemplate {self.task_type} - {self.question}>'
