# app/models/data_model.py

from app import db
from datetime import datetime

class DataSubmission(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    task_id = db.Column(db.Integer, db.ForeignKey('task.id'), nullable=False)
    data = db.Column(db.JSON, nullable=False)  # Store collected data as JSON
    status = db.Column(db.String(50), default='Pending')
    submitted_at = db.Column(db.DateTime, default=datetime.utcnow)

    task = db.relationship('Task', backref='data_submissions')

    def __repr__(self):
        return f'<DataSubmission {self.id}>'
